// Version : Scilab 5.2.2
// Operating Syatem : Ubuntu 16.04 LTS

clc;
clear;
xdel(winsid());
fp= input( " Enter the pass band edge (Hz) = ");
fs= input( "Enter the stop band edge (Hz) = ");
kp= input( "Enter the pass band attenuation (dB) =") ;
ks= input( "Enter the stop band attenuation (dB) = ") ;
//kp= 1.93             //assume the pass band ripple(dB)
//ks= 13.97            //assume the stop band attenuation(dB) 
Fsf=44000;         //sampling frequency
//Converting to digital frequency
Fp1=2*3.14*fp/Fsf;
Fs1=2*3.14*fs/Fsf;

// Digital filter specifications ( rad/samples ) 
N = log10(sqrt((10^(0.1*ks)-1)/(10^(0.1*kp)-1)))/log10(Fs1/Fp1);  //Order of the filter
N = ceil(N);          //rounded to nearest integer
disp(N," IIR Filter order N =");

oc = 0.5*((Fp1*Fsf)/((10^(0.1*kp)-1)^(1/(2*N))) + (Fs1*Fsf)/((10^(0.1*ks)-1)^(1/(2*N))) );  //Cut off Frequency
disp(oc, "Cutoff Frequency in rad/ seconds OC =")
[Hz]=iir(N,'bp','ellip',[Fp1/2,Fs1/2],[0.2,0.200])   //the sum of last matrix [0.2,0.200] must be less than 1  
[p,z,g]=iir(N,'bp','ellip',[Fp1/2,Fs1/2],[0.2,0.200])
[Hw,w]=frmag(Hz,256);
figure(1)
plot(2*w,abs(Hw));
xlabel('Normalized Digital frequency w->')
ylabel('magnitude');
title('Magnitude response of IIR filter')
xgrid(1)
